@echo off
title Starte ... "%~n0"
color 1f
setlocal enabledelayedexpansion

set power=0
if exist %temp%\%~n0.ps1 del %temp%\%~n0.ps1
for /f "tokens=*" %%l in ('type "%~f0"') do (
  if !power!==0 (
    if "%%l"=="*** Ab hier PowerShell ***" set power=1
  ) else (
    echo %%l >> "%temp%\%~n0.ps1"
  )
)
cls
rem echo Starte "%~n0" 
title "%~n0" läuft  ...
powershell -NoProfile -ExecutionPolicy Bypass -File "%temp%\%~n0.ps1" %*
rem TIMEOUT /T 30 /nobreak 
del "%temp%\%~n0.ps1"
rem timeout /t 30
rem pause
exit /b

*** Ab hier PowerShell ***
# Show running .NET-Version
# Stop-Process -Name notepad -Force -ErrorAction SilentlyContinue
$execruntime = [System.Reflection.Assembly]::GetExecutingAssembly().ImageRuntimeVersion
#
$ExportPath = $env:TEMP
$ExportFile = "pc-info-$env:computername.txt"
Remove-Item $ExportPath\$ExportFile -Force -ErrorAction SilentlyContinue
#

# ---- Ausgabe --- START ------ 
$DateTXT = Get-Date -format "dd.MM.yyyy - HH:mm:ss tt"
Write-Output "------------------------------------------------------------------" | Out-File "$ExportPath\$ExportFile" -Encoding utf8
Write-Output "PC-Info Tool - Ver. 2.03.49 (13.05.2024) / .NET Runtime $execruntime" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "Download https:\\www.hekret.de\pcinfo" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "------------------------------------------------------------------`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# Write-Output "`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "Erstellt von Benutzer '$env:userdomain\$env:USERNAME'`r`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "Datensatz erstellt am $DateTXT`r`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#

Write-Host "------------------------------------------------------------------"
Write-Host "PC-Info Tool - Ver. 2.03.49 (13.05.2024) / .NET Runtime $execruntime"
Write-Host "Download https:\\www.hekret.de\pcinfo"
Write-Host "------------------------------------------------------------------`r`n"

# Write-Host "Status:`n"
Write-Host "collecting Data ...  / sammle Daten ...`r`n"
#
# Devce Start ErrorCode
# https://powershell.one/wmi/root/cimv2/win32_pnpentity
$ConfigManagerErrorCode = @{
    Name = 'ConfigManagerErrorCode'
    Expression = {
      # property is an array, so process all values
      $value = $_.ConfigManagerErrorCode
      
      switch([int]$value)
        {
          0          {'This device is working properly.'}
          1          {'This device is not configured correctly.'}
          2          {'Windows cannot load the driver for this device.'}
          3          {'The driver for this device might be corrupted, or your system may be running low on memory or other resources.'}
          4          {'This device is not working properly. One of its drivers or your registry might be corrupted.'}
          5          {'The driver for this device needs a resource that Windows cannot manage.'}
          6          {'The boot configuration for this device conflicts with other devices.'}
          7          {'Cannot filter.'}
          8          {'The driver loader for the device is missing.'}
          9          {'This device is not working properly because the controlling firmware is reporting the resources for the device incorrectly.'}
          10         {'This device cannot start.'}
          11         {'This device failed.'}
          12         {'This device cannot find enough free resources that it can use.'}
          13         {'Windows cannot verify this device''s resources.'}
          14         {'This device cannot work properly until you restart your computer.'}
          15         {'This device is not working properly because there is probably a re-enumeration problem.'}
          16         {'Windows cannot identify all the resources this device uses.'}
          17         {'This device is asking for an unknown resource type.'}
          18         {'Reinstall the drivers for this device.'}
          19         {'Failure using the VxD loader.'}
          20         {'Your registry might be corrupted.'}
          21         {'System failure: Try changing the driver for this device. If that does not work, see your hardware documentation. Windows is removing this device.'}
          22         {'This device is disabled.'}
          23         {'System failure: Try changing the driver for this device. If that doesn''t work, see your hardware documentation.'}
          24         {'This device is not present, is not working properly, or does not have all its drivers installed.'}
          25         {'Windows is still setting up this device.'}
          26         {'Windows is still setting up this device.'}
          27         {'This device does not have valid log configuration.'}
          28         {'The drivers for this device are not installed.'}
          29         {'This device is disabled because the firmware of the device did not give it the required resources.'}
          30         {'This device is using an Interrupt Request (IRQ) resource that another device is using.'}
          31         {'This device is not working properly because Windows cannot load the drivers required for this device.'}
          default    {"$value"}
        }
    }  
  }
# -------------------  Basic Info ---------------- START -------------------
Write-Host "Basic / Allgemein`n"
Write-Output "---------- Basic / Allgemein ---------- START --------------------"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
$OSLanguage = @{
    Name = 'OSLanguage'
    Expression = {
      # property is an array, so process all values
      $value = $_.OSLanguage
#
      switch([int]$value)
        {
            0  {'Unicode'} 
            1025  {'Arabic - Saudi Arabia'} 
            1026  {'Bulgarian'} 
            1027  {'Catalan'} 
            1028  {'Chinese - Taiwan'} 
            1029  {'Czech'} 
            1030  {'Danish'} 
            1031  {'German - Germany'} 
            1032  {'Greek'} 
            1033  {'English - United States'} 
            1034  {'Spanish - Spain (Traditional)'} 
            1035  {'Finnish'} 
            1036  {'French - France'} 
            1037  {'Hebrew'} 
            1038  {'Hungarian'} 
            1039  {'Icelandic'} 
            1040  {'Italian - Italy'} 
            1041  {'Japanese'} 
            1042  {'Korean'} 
            1043  {'Dutch - Netherlands'} 
            1044  {'Norwegian - Bokmaal'} 
            1045  {'Polish'} 
            1046  {'Portuguese - Brazil'} 
            1047  {'Raeto-Romance'} 
            1048  {'Romanian - Romania'} 
            1049  {'Russian'} 
            1050  {'Croatian'} 
            1051  {'Slovak'} 
            1052  {'Albanian'} 
            1053  {'Swedish - Sweden'} 
            1054  {'Thai'} 
            1055  {'Turkish'} 
            1056  {'Urdu'} 
            1057  {'Indonesian'} 
            1058  {'Ukrainian'} 
            1059  {'Belarusian'} 
            1060  {'Slovenian'} 
            1061  {'Estonian'} 
            1062  {'Latvian'} 
            1063  {'Lithuanian'} 
            1064  {'Tajik'} 
            1065  {'Farsi - Persian'} 
            1066  {'Vietnamese'} 
            1067  {'Armenian'} 
            1068  {'Azeri - Latin'} 
            1069  {'Basque'} 
            1070  {'Sorbian'} 
            1071  {'FYRO Macedonia'} 
            1072  {'Sesotho (Sutu)'} 
            1073  {'Tsonga'} 
            1074  {'Setsuana'} 
            1075  {'Venda'} 
            1076  {'Xhosa'} 
            1077  {'Zulu'} 
            1078  {'Afrikaans'} 
            1079  {'Georgian'} 
            1080  {'Faroese'} 
            1081  {'Hindi'} 
            1082  {'Maltese'} 
            1083  {'Sami Lappish'} 
            1084  {'Gaelic - Scotland'} 
            1085  {'Yiddish'} 
            1086  {'Malay - Malaysia'} 
            1087  {'Kazakh'} 
            1088  {'Kyrgyz - Cyrillic'} 
            1089  {'Swahili'} 
            1090  {'Turkmen'} 
            1091  {'Uzbek - Latin'} 
            1092  {'Tatar'} 
            1093  {'Bengali - India'} 
            1094  {'Punjabi'} 
            1095  {'Gujarati'} 
            1096  {'Oriya'} 
            1097  {'Tamil'} 
            1098  {'Telugu'} 
            1099  {'Kannada'} 
            1100  {'Malayalam'} 
            1101  {'Assamese'} 
            1102  {'Marathi'} 
            1103  {'Sanskrit'} 
            1104  {'Mongolian'} 
            1105  {'Tibetan'} 
            1106  {'Welsh'} 
            1107  {'Khmer'} 
            1108  {'Lao'} 
            1109  {'Burmese'} 
            1110  {'Galician'} 
            1111  {'Konkani'} 
            1112  {'Manipuri'} 
            1113  {'Sindhi'} 
            1114  {'Syriac'} 
            1115  {'Sinhala; Sinhalese'} 
            1118  {'Amharic'} 
            1120  {'Kashmiri'} 
            1121  {'Nepali'} 
            1122  {'Frisian - Netherlands'} 
            1124  {'Filipino'} 
            1125  {'Divehi; Dhivehi; Maldivian'} 
            1126  {'Edo'} 
            1136  {'Igbo - Nigeria'} 
            1140  {'Guarani - Paraguay'} 
            1142  {'Latin'} 
            1143  {'Somali'} 
            1153  {'Maori'} 
            1279  {'HID (Human Interface Device)'} 
            2049  {'Arabic - Iraq'} 
            2052  {'Chinese - China'} 
            2055  {'German - Switzerland'} 
            2057  {'English - Great Britain'} 
            2058  {'Spanish - Mexico'} 
            2060  {'French - Belgium'} 
            2064  {'Italian - Switzerland'} 
            2067  {'Dutch - Belgium'} 
            2068  {'Norwegian - Nynorsk'} 
            2070  {'Portuguese - Portugal'} 
            2072  {'Romanian - Moldova'} 
            2073  {'Russian - Moldova'} 
            2074  {'Serbian - Latin'} 
            2077  {'Swedish - Finland'} 
            2092  {'Azeri - Cyrillic'} 
            2108  {'Gaelic - Ireland'} 
            2110  {'Malay - Brunei'} 
            2115  {'Uzbek - Cyrillic'} 
            2117  {'Bengali - Bangladesh'} 
            2128  {'Mongolian'} 
            3073  {'Arabic - Egypt'} 
            3076  {'Chinese - Hong Kong SAR'} 
            3079  {'German - Austria'} 
            3081  {'English - Australia'} 
            3084  {'French - Canada'} 
            3098  {'Serbian - Cyrillic'} 
            4097  {'Arabic - Libya'} 
            4100  {'Chinese - Singapore'} 
            4103  {'German - Luxembourg'} 
            4105  {'English - Canada'} 
            4106  {'Spanish - Guatemala'} 
            4108  {'French - Switzerland'} 
            5121  {'Arabic - Algeria'} 
            5124  {'Chinese - Macau SAR'} 
            5127  {'German - Liechtenstein'} 
            5129  {'English - New Zealand'} 
            5130  {'Spanish - Costa Rica'} 
            5132  {'French - Luxembourg'} 
            5146  {'Bosnian'} 
            6145  {'Arabic - Morocco'} 
            6153  {'English - Ireland'} 
            6154  {'Spanish - Panama'} 
            6156  {'French - Monaco'} 
            7169  {'Arabic - Tunisia'} 
            7177  {'English - Southern Africa'} 
            7178  {'Spanish - Dominican Republic'} 
            7180  {'French - West Indies'} 
            8193  {'Arabic - Oman'} 
            8201  {'English - Jamaica'} 
            8202  {'Spanish - Venezuela'} 
            9217  {'Arabic - Yemen'} 
            9225  {'English - Caribbean'} 
            9226  {'Spanish - Colombia'} 
            9228  {'French - Congo'} 
            10241  {'Arabic - Syria'} 
            10249  {'English - Belize'} 
            10250  {'Spanish - Peru'} 
            10252  {'French - Senegal'} 
            11265  {'Arabic - Jordan'} 
            11273  {'English - Trinidad'} 
            11274  {'Spanish - Argentina'} 
            11276  {'French - Cameroon'} 
            12289  {'Arabic - Lebanon'} 
            12297  {'English - Zimbabwe'} 
            12298  {'Spanish - Ecuador'} 
            12300  {"'French - Cote d'Ivoire'"} 
            13313  {'Arabic - Kuwait'} 
            13321  {'English - Phillippines'} 
            13322  {'Spanish - Chile'} 
            13324  {'French - Mali'} 
            14337  {'Arabic - United Arab Emirates'} 
            14346  {'Spanish - Uruguay'} 
            14348  {'French - Morocco'} 
            15361  {'Arabic - Bahrain'} 
            15370  {'Spanish - Paraguay'} 
            16385  {'Arabic - Qatar'} 
            16393  {'English - India'} 
            16394  {'Spanish - Bolivia'} 
            17418  {'Spanish - El Salvador'} 
            18442  {'Spanish - Honduras'} 
            19466  {'Spanish - Nicaragua'} 
            20490  {'Spanish - Puerto Rico'}
                    default    {"$value"}
           }
      }  
   }
#
$domain = (Get-CimInstance Win32_ComputerSystem).Domain
#
# ActiveDirectory Site abfragen und Fehler abfangen.
try {
    $adsite = [System.DirectoryServices.ActiveDirectory.ActiveDirectorySite]::GetComputerSite().Name
    }
    catch
    {
    # Write-Host $PSItem.Exception.Message
    Set-Variable -Name adsite -Value "-"
    }
#
#
$dr = Get-CimInstance -Class win32_computersystem | Select-Object -ExpandProperty domainrole
$domainrole = switch ($dr) {
    0 {"Standalone Workstation"} 
    1 {"Member Workstation"} 
    2 {"Standalone Server"} 
    3 {"Member Server"} 
    4 {"Backup Domain Controller"} 
    5 {"Primary Domain Controller"} 
    default {"Unknown"} 
    } # end switch
#
#
# OperatingSystem Name (Full Qualified) 
$OSName=(Get-CimInstance Win32_OperatingSystem).caption
#
# Operating System Architecture
$OSArch=(Get-CimInstance Win32_OperatingSystem).OSArchitecture
#
# Operating System Release-ID / Win 10 only
# $OSReleaseID=(Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion").ReleaseId # Win 10 only
$OSVersionID=(Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion").DisplayVersion # Win 10 only
$OSReleaseID=(Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion").ReleaseId # Win 10 only
# $OSReleaseID=(Get-ItemProperty "HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion").DisplayVersion # Win 10 only
#
# Operating System Version 
$OSVersion = (Get-CimInstance Win32_OperatingSystem).version
$UBR = (Get-ItemProperty -Path 'HKLM:\SOFTWARE\Microsoft\Windows NT\CurrentVersion').UBR
#
$sysdrive = (Get-CimInstance Win32_OperatingSystem).SystemDrive
$windir = (Get-CimInstance Win32_OperatingSystem).WindowsDirectory
$boottime = (Get-CimInstance Win32_OperatingSystem).LastBootUpTime.tostring("G")
$localtime = (Get-CimInstance Win32_OperatingSystem).LocalDateTime.tostring("G")
$lastinstupgrade = (Get-CimInstance Win32_OperatingSystem).InstallDate.tostring("G")
$osmanufac = (Get-CimInstance Win32_OperatingSystem).Manufacturer
$currpagingFile = (Get-CimInstance Win32_OperatingSystem).SizeStoredInPagingFiles
$currnrofproc = (Get-CimInstance Win32_OperatingSystem).NumberOfProcesses 
$osbuildtype =  (Get-CimInstance Win32_OperatingSystem).BuildType
$osmuilang = (Get-CimInstance Win32_OperatingSystem).MUILanguages 
$oslangcp = Get-CimInstance Win32_OperatingSystem | select-Object OSLanguage | Format-Table $OSLanguage -HideTableHeaders | Out-String -Width 50 -Stream
#
#
#
# $CompType = Get-CimInstance -Class:Win32_ComputerSystem | Select-Object Manufacturer,Model | Format-Table -HideTableHeaders | Out-String -Stream
$CompManufac = (Get-CimInstance -Class:Win32_ComputerSystem).Manufacturer
$CompModel = (Get-CimInstance -Class:Win32_ComputerSystem).Model
$CompSerial = (Get-CimInstance -Class Win32_BIOS).SerialNumber
$CompVersion = (Get-CimInstance -Class  Win32_ComputerSystemProduct).Version
$UUIDhw =  (Get-CimInstance -Class  Win32_ComputerSystemProduct).UUID
#
# BIOS Versions-Nr
$BiosVersion = (Get-CimInstance -Class:win32_bios).SMBIOSBIOSVersion
#
$machinename = (Get-CimInstance -Class:Win32_Computersystem).Name
#
# $ram = (Get-CimInstance Win32_ComputerSystem | Select-Object @{LABEL='TotalRAM (MB)';EXPRESSION={"{0:N0}" -f ($_.TotalPhysicalMemory/1MB)} })."TotalRAM (MB)"
$ram = "$(((Get-CimInstance -class "win32_physicalmemory" -namespace "root\CIMV2").Capacity | Measure-Object -Sum).Sum/1GB) GB"
$RamTotalSlots = ((Get-CimInstance -Class "win32_PhysicalMemoryArray" -namespace "root\CIMV2").MemoryDevices | Measure-Object -Sum).Sum
$RamUsedSlots = ((Get-CimInstance -class "win32_physicalmemory" -namespace "root\CIMV2") | Measure-Object).Count 
#
write-Output "
Hardware Info (Base):
    Manufacturer: ............... $CompManufac
    Model: ...................... $CompModel`
    Hardware-Version: ........... $CompVersion`
    Serial-Nr.: ................. $CompSerial`
    BIOS Version: ............... $BiosVersion`
    UUID (Hardware): ............ $UUIDhw
RAM:`
    RAM total: .................. $ram`
    Used Slots: ................. $RamUsedSlots`
    Total Slots: ................ $RamTotalSlots`
`
Operating System:`
    Manufacturer: ............... $osmanufac`
    Name: ....................... $OSName`
    Architecture: ............... $OSArch `
    Build Type: ................. $osbuildtype`
    Version: .................... $OSVersion`
    Update Build Revision (UBR):  $UBR`
    Release/Version: ............ $OSReleaseID / $OSVersionID`
    Local Time: ................. $localtime`
    Last Boot Time: ............. $boottime`
`
    Last Install/Upgrade: ....... $lastinstupgrade`
    System Drive: ............... $sysdrive`
    Windows Directory: .......... $windir`
    Paging File Size: ........... $currpagingFile`
    Current Number of Processes:  $currnrofproc`
    Installed Base Language: ... $OSLangcp`
    Installed MUI Language(s): .. $osmuilang`
`
Domain Machine Info:`
    Computername: ............... $machinename`
    ActiveDirectory: ............ $domain`
    Site: ....................... $adsite`
    Domain Role: ................ $domainrole`
`
Domain User Info:`
    ActiveDirectory: ............ $env:userdomain`
    LogonServer: ................ $env:logonserver`
    UserName: ................... $env:USERNAME`
    User Profile Folder: ........ $env:USERPROFILE" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# $ram = (Get-CimInstance Win32_ComputerSystem | Select-Object @{LABEL='TotalRAM (MB)';EXPRESSION={"{0:N0}" -f ($_.TotalPhysicalMemory/1MB)} })."TotalRAM (MB)"
# Write-Output "RAM gesamt:       $ram MB" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# -------------------  Basic Info ---------------- END -------------------
#
# -------------------  Systemordner Pfade / System Folder Paths ---------------- START -------------------
Write-Host "Systemordner Pfade / System Folder Paths `n"
Write-Output "---------- Systemordner Pfade / System Folder Paths ---------- START --------------------"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

# https://docs.microsoft.com/en-us/dotnet/api/system.environment.specialfolder?redirectedfrom=MSDN&view=netcore-3.1
#

# [environment]::getfolderpath("MyComputer") # Win10 = Useless
#

$AllUserStartmenu=[environment]::getfolderpath("CommonStartMenu")
$AllUserStartmenuProgs=[environment]::getfolderpath("CommonPrograms")
$AllUserStartup=[environment]::getfolderpath("CommonStartup")
$AllUserDesktop=[environment]::getfolderpath("CommonDesktopDirectory")
$AllUserTemplates=[environment]::getfolderpath("CommonTemplates")
$AllUserDocuments=[environment]::getfolderpath("CommonDocuments")
$AllUserMusic=[environment]::getfolderpath("CommonMusic")
$AllUserPictures=[environment]::getfolderpath("CommonPictures")
$AllUserVideo=[environment]::getfolderpath("CommonVideos")


$SystemWindows=[environment]::getfolderpath("Windows")
$SystemSystem=[environment]::getfolderpath("System")
$SystemSystemx86=[environment]::getfolderpath("SystemX86")

$SystemTEMP=[System.Environment]::GetEnvironmentVariable('TEMP','Machine')
$SystemTMP=[System.Environment]::GetEnvironmentVariable('TMP','Machine')

$SystemFonts=[environment]::getfolderpath("Fonts")
$SystemProgramFiles=[environment]::getfolderpath("ProgramFiles")
$SystemProgramFilesCommFiles=[environment]::getfolderpath("CommonProgramFiles")
$SystemProgramFilesx86=[environment]::getfolderpath("ProgramFilesX86")
$SystemProgramFilesx86CommFiles=[environment]::getfolderpath("CommonProgramFilesX86")
$SystemProgramData=[environment]::getfolderpath("CommonApplicationData")
#
$SystemStartmenuAdminTools=[environment]::getfolderpath("CommonAdminTools")
$SystemRessources=[environment]::getfolderpath("Resources")
# -------------------------------------------



write-Output "`
/--------------------------\ `
`
# All User (Public) Folders `
Desktop: ................. $AllUserDesktop
Documents / Dokumente: ... $AllUserDocuments
Pictures / Bilder: ....... $AllUserPictures
Music: ................... $AllUserMusic
Videos: .................. $AllUserVideo

Templates / Vorlagen: .....$AllUserTemplates

Startmenu / Startmen: ........................ $AllUserStartmenu
Startmenu Programs / Startmen Programme: ..... $AllUserStartmenuProgs
Startup / Autostart: .......................... $AllUserStartup
Administrative Tools / Administrator Tools: ... $SystemStartmenuAdminTools
`
\--------------------------/`
`
/--------------------------\ `
`
Windows Install Directory: .......... $SystemWindows`
System (Main-)Folder: ............... $SystemSystem`
System (32-Bit)Folder: .............. $SystemSystemx86`
`
TMP (Temp-Folder): .................. $SystemTMP`
TEMP (Temp-Folder): ................. $SystemTEMP`

Fonts / Schriftarten: ............... $SystemFonts`
`
Programs (Main-)Folder:.............. $SystemProgramFiles`
CommonFiles of Programs (Main): ..... $SystemProgramFilesCommFiles`
Programs (32-Bit)Folder:............. $SystemProgramFilesx86`
CommonFiles of Programs (32-Bit): ... $SystemProgramFilesx86CommFiles`
ProgramData: ........................ $SystemProgramData`
`
System Ressounces: .................. $SystemRessources`
`
\--------------------------/" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# -------------------  Systemordner Pfade / System Folder Paths ---------------- END -------------------
#

# "------- Variables (User / System / Process ) / Variablen (Benutzer / System / Prozesse ) --- Start -------------------------------------------------------------------"
Write-Host "Variables (User / System / Process ) / Variablen (Benutzer / System / Prozesse )`n"
Write-Output "---------------- Variables (User / System / Process ) / Variablen (Benutzer / System / Prozesse ) ------------------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# Write-Output "Machine environment variables" 
$VarMachine = [Environment]::GetEnvironmentVariables("Machine")

# Write-Output "User environment variables" 
$VarCurrUser = [Environment]::GetEnvironmentVariables("User")

# Write-Host - This should be the same as 'Get-ChildItem env:', although it isn't sorted.
# Write-Output "Process environment variables" 
$VarProcess = [Environment]::GetEnvironmentVariables("Process")

Write-Output "-------------------------------------------------------- `
`
Machine environment variables: `
`
" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
$VarMachine | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Output "-------------------------------------------------------- `
`
User environment variables:`
`
" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
$VarCurrUser | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Output "-------------------------------------------------------- `
`
Process environment variables: 
`
" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
$VarProcess | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "`
`--------------------------------------------------------" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "Machine Certificates / Computer Zertifikate`n"
Write-Output "------ Machine Certificates / Computer Zertifikate ------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# Get-ChildItem Cert:\LocalMachine\My | Select-Object Subject,Issuer,Thumbprint,NotAfter | Format-List | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-ChildItem Cert:\LocalMachine\My | Select-Object PolicyId,Subject,Issuer,Thumbprint,Version,Handle,NotBefore,NotAfter | Format-List | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# Update 2022-05-06 - IP-List fixed
# -------------------  Hardware Info ---------------- START -------------------
#
Write-Host "Network + DNS-Names / Netzwerk + DNS-Name`n"
Write-Output "----- Network + DNS-Names / Netzwerk + DNS-Name ------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Import-Module -Name NetAdapter

# List all Network-Adapters
Get-NetAdapter | `
		# Where-Object -FilterScript { ($PSItem.MacAddress -gt "0") } | `
        # Sort-Object -Property Name -Descending  | `
        Sort-Object -Property Status,Name -Descending  | `
		Format-Table -AutoSize | Out-File  -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

# active IP-Addresses
Get-NetAdapter | Where-Object -FilterScript { `
	# ($PSItem.MacAddress -gt "0")  -and `
	($PSItem.Status -eq "Up") } -ErrorAction SilentlyContinue | get-netipaddress -ErrorAction Continue | `
	Select-Object InterfaceAlias,AddressFamily,IPAddress,PrefixOrigin,ValidLifeTime,PreferredLifeTime  | `
	Sort-Object -Property AddressFamily | Format-Table -AutoSize | Out-File  -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

# DNS-Names
 (Get-NetAdapter | Where-Object -FilterScript { `
	# ($PSItem.MacAddress -gt "0") -and `
	($PSItem.Status -eq "Up") } | get-netipaddress -ErrorAction Continue ).IPAddress | `
	Resolve-DnsName -NoHostsFile -DnsOnly -Type PTR -ErrorAction SilentlyContinue | `
	Where-Object Type -eq 'PTR' | Format-Table -AutoSize | Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append


# Get-CimInstance -Class CIM_NetworkAdapter | Where-Object -FilterScript { `
# 	($PSItem.MacAddress -gt "0") }  | get-netipaddress -ErrorAction Continue | Select-Object InterfaceAlias,AddressFamily,IPAddress,PrefixOrigin,ValidLifeTime,PreferredLifeTime  | `
#	Format-Table -AutoSize  # | Out-File  -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "Drives / Laufwerke`n"
Write-Output "---------------- Drives / Laufwerke  ----------------- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# Physical Drives
# Get-CimInstance -ClassName Win32_diskdrive | fl *
# Get-PhysicalDisk | fl *
Get-PhysicalDisk | Select-Object FriendlyName,BusType,SerialNumber,FirmwareVersion,MediaType,@{Name='Size(GB)';Exp={$_.Size /1Gb -as [int]}},HealthStatus,OperationalStatus | Format-Table -AutoSize |`
     Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
     # ---------------------------------------------------------------------------------------------------
#
<#
.SYNOPSIS
Get information about the physical disks and volumes on a system.
#
.DESCRIPTION
Get details about the physical disks and the volumes located on
those disks, to make it easier to identify corresponding vSphere
storage (VMDKs).
#
.EXAMPLE
#
PS C:\> .\Get-DiskInfo.ps1
#
.NOTES
    Author: Geoff Duke <Geoffrey.Duke@uvm.edu>
    Based on http://bit.ly/XowLns and http://bit.ly/XeIqFh
	Modified by Heiko Kretschmer 
	Based on https://www.uvm.edu/~gcd/2013/01/which-disk-is-that-volume-on/
#>
#
# Set-PSDebug -Strict
#
Function Main {
#
    $diskdrives = get-CimInstance Win32_DiskDrive | Sort-Object Index
#
    $colSize = @{Name='Size';Expression={Get-HRSize $_.Size}}
#
    foreach ( $disk in $diskdrives ) {
#
#        $scsi_details = 'SCSI ' + $disk.SCSIBus         + ':' +
#                                  $disk.SCSILogicalUnit + ':' +
#                                  $disk.SCSIPort        + ':' +
#                                  $disk.SCSITargetID
#        Write-Output $( $disk.Caption + ' - ' + 'Disk ' + $disk.Index + ' - ' + $scsi_details +
        Write-Output $( $disk.Caption + ' - ' + 'Disk ' + $disk.Index +
                 ' - ' + ( Get-HRSize $disk.size) )
#
        $physicaldrv = $disk.Caption
        $part_query = 'ASSOCIATORS OF {Win32_DiskDrive.DeviceID="' +
                      $disk.DeviceID.replace('\','\\') +
                      '"} WHERE AssocClass=Win32_DiskDriveToDiskPartition'
#
        $partitions = @( Get-CimInstance -query $part_query | 
                         Sort-Object StartingOffset )
        foreach ($partition in $partitions) {
#
            $vol_query = 'ASSOCIATORS OF {Win32_DiskPartition.DeviceID="' +
                         $partition.DeviceID +
                         '"} WHERE AssocClass=Win32_LogicalDiskToPartition'
            $volumes   = @(get-CimInstance -query $vol_query)
#
            Write-Output $( '    Partition ' + $partition.Index + '  ' +
                     ( Get-HRSize $partition.Size) + '  ' +
                     $partition.Type
                   )
#
            foreach ( $volume in $volumes) {
                Write-Output $( '        ' + $volume.name + 
                         ' [' + $volume.FileSystem + '] ' + 
                         ( Get-HRSize $volume.Size ) + ' ( ' +
                         ( Get-HRSize $volume.FreeSpace ) + ' free )'
                       )
#
            } # end foreach vol
#
        } # end foreach part
#
        write ''
#
    } # end foreach disk
#
}
#
#---------------
function Get-HRSize {
    [CmdletBinding()]
    param(
        [Parameter(Mandatory=$True, ValueFromPipeline=$True)]
        [INT64] $bytes
    )
    process {
        if     ( $bytes -gt 1pb ) { "{0:N2} PB" -f ($bytes / 1pb) }
        elseif ( $bytes -gt 1tb ) { "{0:N2} TB" -f ($bytes / 1tb) }
        elseif ( $bytes -gt 1gb ) { "{0:N2} GB" -f ($bytes / 1gb) }
        elseif ( $bytes -gt 1mb ) { "{0:N2} MB" -f ($bytes / 1mb) }
        elseif ( $bytes -gt 1kb ) { "{0:N2} KB" -f ($bytes / 1kb) }
        else   { "{0:N} Bytes" -f $bytes }
    }
} # End Function:Get-HRSize
#
Main | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# ---------------------------------------------------------------------------------------------------
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "Hardware / Geraete`n`n"
Write-Output "---------------- Hardware / Geraete ------------------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#

Write-Host "-- angeschlossene Monitore / connected Displays -- `n"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "##-- angeschlossene Monitore / connected Displays --##" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
ForEach ($Monitor in Get-CimInstance -ClassName WmiMonitorID -Namespace root\wmi)
{
    $Manufacturer = ($Monitor.ManufacturerName  | ForEach-Object{[char]$_}) -join ""
    $Name = ($Monitor.UserFriendlyName| ForEach-Object{[char]$_}) -join ""
    $Serial = ($Monitor.SerialNumberID | ForEach-Object{[char]$_}) -join ""
    $ManWeek = $Monitor.WeekOfManufacture
    $ManYear = $Monitor.YearOfManufacture
# write-host "
# Manufacturer:      $Manufacturer`
# Type:              $Name`
# Serial Nr.         $Serial`
# WeekOfManufacture: $ManWeek`
# YearOfManufacture: $ManYear`n"
#
Write-Output "
Manufacturer:      $Manufacturer`
Type:              $Name`
Serial Nr.         $Serial`
WeekOfManufacture: $ManWeek`
YearOfManufacture: $ManYear`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
}
#

# Mainboard
#
Write-Host "-- Hauptplatine / Mainboard -- `n"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "##-- Hauptplatine / Mainboard --##" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance Win32_BaseBoard | `
    Select-Object Name,Status,Manufacturer,Product,SerialNumber,Version,PartNumber,SKU,Replaceable,ConfigOptions,RequiresDaughterBoard,Depth,Height |`
    Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# CPU Data
Write-Host "-- Prozessor / CPU --`n"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "##-- Prozessor / CPU --##" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance win32_processor |`
    Select-Object DeviceID,SocketDesignation,Status,Manufacturer,Name,Caption,NumberOfCores,NumberOfEnabledCore,NumberOfLogicalProcessors,PartNumber,AddressWidth,DataWidth,ExtClock,L2CacheSize,L2CacheSpeed,L3CacheSize,L3CacheSpeed,PowerManagementSupported,CurrentClockSpeed,CpuStatus,CurrentVoltage,LoadPercentage |`
    format-list | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# https://docs.microsoft.com/en-us/windows/win32/cimwin32prov/win32-processor
#
# RAM
Write-Host "-- Arbeitsspeicher / RAM -- `n"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "##-- Arbeitsspeicher / RAM --##" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# Get-CimInstance -class "Win32_PhysicalMemory" | format-list *
Get-CimInstance -class Win32_Physicalmemory | Select-Object Tag,DeviceLocator,Manufacturer,PartNumber,SerialNumber,Capacity,Speed,ConfiguredVoltage | Format-Table |`
    Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# GraphicCard
Write-Host "-- Grafikkarte / GraphicCard -- `n"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "##-- Grafikkarte / GraphicCard --##" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Get-CimInstance Win32_VideoController | `
    Select-Object -Property DeviceID,Name,VideoProcessor,VideoModeDescription,AdapterDACType,MaxRefreshRate,MinRefreshRate,CurrentBitsPerPixel,CurrentHorizontalResolution,CurrentVerticalResolution,CurrentRefreshRate,CurrentNumberOfColors,AdapterCompatibility,InfFilename,InfSection,PNPDeviceID | `
    Format-List | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "Audio Devices / Audiogeraete`n"
Write-Output "------------ Audio Devices / Audiogeraete ------------- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Get-CimInstance win32_sounddevice | Select-Object Manufacturer,Name,PNPDeviceID,Status,StatusInfo,$ConfigManagerErrorCode  | `
    Format-Table | Out-File -Width 500  "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Add-Type -TypeDefinition @'
using System.Runtime.InteropServices;
[Guid("D666063F-1587-4E43-81F1-B948E807363F"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
interface IMMDevice {
    int a(); int o();
    int GetId([MarshalAs(UnmanagedType.LPWStr)] out string id);
}
[Guid("A95664D2-9614-4F35-A746-DE8DB63617E6"), InterfaceType(ComInterfaceType.InterfaceIsIUnknown)]
interface IMMDeviceEnumerator {
    int f();
    int GetDefaultAudioEndpoint(int dataFlow, int role, out IMMDevice endpoint);
}
[ComImport, Guid("BCDE0395-E52F-467C-8E3D-C4579291692E")] class MMDeviceEnumeratorComObject { }
public class Audio {
    public static string GetDefault (int direction) {
    var enumerator = new MMDeviceEnumeratorComObject() as IMMDeviceEnumerator;
    IMMDevice dev = null;
    Marshal.ThrowExceptionForHR(enumerator.GetDefaultAudioEndpoint(direction, 1, out dev));
    string id = null;
    Marshal.ThrowExceptionForHR(dev.GetId(out id));
    return id;
    }
}
'@
#
function getFriendlyName($id) {
    $reg = "HKLM:\SYSTEM\CurrentControlSet\Enum\SWD\MMDEVAPI\$id"
    return (get-ItemProperty $reg).FriendlyName
}
#
$id0 = [audio]::GetDefault(0)
$id1 = [audio]::GetDefault(1)
# write-host "Default Speaker: $(getFriendlyName $id0)" 
# write-host "Default Micro  : $(getFriendlyName $id1)"
Write-Output "Default Speaker: $(getFriendlyName $id0)" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "Default Micro  : $(getFriendlyName $id1)" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#

Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#

Write-Host "PnP Devices / PnP-Geraete`n"
Write-Output "------------ PnP Devices / PnP-Geraete --------------- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

  # Devices with Error
Write-Output "--- not working / nicht funktionierend ---" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance -query "select * from Win32_PnpEntity" | Where-Object {$_.ConfigManagerErrorCode -gt 0 } |`
      Format-Table -autosize Caption,DeviceID,$ConfigManagerErrorCode | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding utf8 -Append

write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

  # Devices OK
Write-Output "--- working / funktionierend ---" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance -query "select * from Win32_PnpEntity" | Where-Object {$_.ConfigManagerErrorCode -ceq 0 } | `
    Format-Table -autosize Caption,DeviceID,$ConfigManagerErrorCode | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding utf8 -Append

# Get-PnpDevice | Where-Object {$_.Status -ne "Error" } | Sort-Object -Property Class | Out-GridView
# Get-PnpDevice | Where-Object {$_.Status -eq "Error" } | Out-GridView
# Get-PnpDevice | Where-Object {$_.Status -eq "OK" } | Out-GridView

# write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

# Write-Output "--- unknown Devices (offline / disconnected) / unbekannte (ausgeschaltet / getrennte)  ---"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# Get-PnpDevice | Where-Object {$_.Status -eq "Unknown" } | Sort-Object -Property Class | Format-Table -autosize | Out-File -Width 800 "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# "------- Virtual Ports - Serial (COM:), Paralell (LPT:) / Virtuelle Ports - Seriell (COM:), Paralell (LPT:) --- Start -------------------------------------------------------------------"
Write-Host "Virtual Ports - Serial (COM:), Paralell (LPT:) / Virtuelle Ports - Seriell (COM:), Paralell (LPT:)`n"
Write-Output "---------------- Virtual Ports - Serial (COM:), Paralell (LPT:) / Virtuelle Ports - Seriell (COM:), Paralell (LPT:) ------------------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Output "--- Serial (COM:)  --- " | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance Win32_SerialPort | Select-Object Caption,Description, Status, ConfigManagerErrorCode, InstallDate | Format-Table -AutoSize  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Output "--- Paralell (LPT:) --- " | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Get-CimInstance Win32_ParallelPort | Select-Object Caption,Description, Status, ConfigManagerErrorCode, InstallDate | Format-Table -AutoSize  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Host "installed Device Drivers / installierte Gertetreiber`n"
Write-Output "------------ installed Device Drivers / installierte Gertetreiber --------------- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Start-Sleep 1

#
  # DeviceDriver
Get-CimInstance Win32_PnPSignedDriver| Select-Object DeviceName, DeviceID, DriverProviderName, Manufacturer, DriverVersion, DriverDate | Sort-Object -Property DeviceName | Format-Table -AutoSize | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding utf8 -Append

#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Host "Local Group Member / Lokale Gruppen Mitgliedschaften `n"
Write-Output "---- Local Group Member / Lokale Gruppen Mitgliedschaften ----- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding ascii -Append
write-Output "`n`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding ascii -Append
#
#Get-LocalGroup | ForEach-Object {
#        $group = $_
#        return [PSCustomObject]@{ 
#            "Group"   = $group.Name
#            "Members" = $group | Get-LocalGroupMember | Select-Object -ExpandProperty "Name"
#        } 
#    } | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding ascii -Append


Get-LocalGroup | %{ $groups = "$(Get-LocalGroupMember -Group $_.Name | %{ $_.Name } | Out-String)"; Write-Output "$($_.Name)>`r`n$($groups)`r`n" }  | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding ascii -Append

#
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding ascii -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding ascii -Append
#
# "------- license status (Win / Office / other MS) / Lizenzstatus (Win / Office / other MS) --- Start -------------------------------------------------------------------"
Write-Host "license status (Win / Office / other MS) / Lizenzstatus (Win / Office / other MS)`n"
Write-Output "------- license status (Win / Office / other MS) / Lizenzstatus (Win / Office / other MS) ------- START ----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
$LicenseStatus = @{
    Name = 'LicenseStatus'
    Expression = {
      # property is an array, so process all values
      $value = $_.LicenseStatus
      
      switch([int]$value)
        {
          0          {'Unlicensed'}
          1          {'Licensed'}
          2          {'OOBGrace = Out-of-Box Grace'}
          3          {'OOTGrace = Out of Tolerance Grace'}
          4          {'NonGenuineGrace'}
          5          {'Notification'}
          6          {'ExtendedGrace'}
          default    {"$value"}
        }
    }  
  }

# Fast - 5 Sek
Get-CimInstance SoftwareLicensingProduct -Filter 'ProductKeyId != NULL' | Where-Object { $_.PartialProductKey } | `
Select-Object Description, $LicenseStatus, LicenseFamily, Name, PartialProductKey, ProductKeyChannel  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Host "Software + Apps (Userprofile / 64-Bit / 32-Bit)`n"
# Get-CimInstance -Class Win32_Product | Select-Object -Property Name,Version,Vendor,IdentifyingNumber | Format-Table -AutoSize)
#
# Software-List UserProfile
Write-Host "-- Windows - Software-List (UserProfile) --"
Write-Output "------- Windows - Software-List (UserProfile) ------- START ----`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Get-ItemProperty HKCU:\Software\Microsoft\Windows\CurrentVersion\Uninstall\* | Where-Object { ($_.DisplayName -gt "0" ) } | `
	Select-Object DisplayName, DisplayVersion, Publisher, InstallDate | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap | `
	Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#
# 64 Software-List @ 64-Bit Windows
# 32 Software-List @ 32-Bit Windows 
Write-Host "-- Windows Native - 64-bit - Software-List (Machine) --"
write-Output "------- Windows Native - 64-bit - Software-List (Machine) ------- START ----`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Get-ItemProperty HKLM:\Software\Microsoft\Windows\CurrentVersion\Uninstall\* | Where-Object { ($_.DisplayName -gt "0" ) } | `
	Select-Object DisplayName, DisplayVersion, Publisher, InstallDate | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap | `
	Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# 32-Bit Software-List @ 64-Bit Windows
#
Write-Host "-- Windows - 32-Bit - Software-List (Machine) --"
Write-Output "------- Windows - 32-Bit - Software-List (Machine) ------- START ----`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Get-ItemProperty HKLM:\SOFTWARE\Wow6432Node\Microsoft\Windows\CurrentVersion\Uninstall\* | Where-Object { ($_.DisplayName -gt "0" ) } | `
	Select-Object DisplayName, DisplayVersion, Publisher, InstallDate | Sort-Object -Property DisplayName | Format-Table -AutoSize -Wrap | `
	Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# ------------------- Software List ---------------- END -------------------
#
# "------- Apps-List UserProfile (without/ohne FrameWorks, NonRemovable-Apps) --- Start -------------------------------------------------------------------"
Write-Host "Apps-List UserProfile (without/ohne FrameWorks, NonRemovable-Apps)`n"
Write-Output "------- Apps-List UserProfile (without/ohne FrameWorks, NonRemovable-Apps) ------- START ----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# Apps-List UserProfile (without/ohne FrameWorks, NonRemovable-Apps)
Get-AppxPackage -User $env:username | `
    Where-Object  -FilterScript { ($PSItem.NonRemovable -eq $False) -and  ($PSItem.IsFramework -eq $False)  } | `
#    Select-Object Name,Architecture,Version,PackageFullName,PackageFamilyName,Publisher,PublisherId,InstallLocation | `
    Select-Object Name,Architecture,Version,NonRemovable,PublisherId,InstallLocation | `
    Sort-Object -Property Name | Format-Table -AutoSize -Wrap | `
    Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
	
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
# Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# "------- Framewwork Apps  --- Start -------------------------------------------------------------------"
Write-Host "Framewwork Apps `n"
Write-Output "------- Framewwork Apps ------- START ----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# FrameWork Apps
Get-AppxPackage | `
	Where-Object  -FilterScript { ($PSItem.IsFramework -eq $True) } | `
#	Select-Object Name,Architecture,Version,NonRemovable,PackageFullName,PackageFamilyName,Publisher,PublisherId | `
	Select-Object Name,Architecture,Version,NonRemovable,PublisherId,InstallLocation | `
	Sort-Object -Property Name | Sort-Object -Property Name | Format-Table -AutoSize -Wrap  | `
	Out-File -Width 500 -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# "------- Autorun Programs / Autostart Programme --- Start -------------------------------------------------------------------"
Write-Host "Autorun Programs / Autostart Programme`n"
Write-Output "---------------- Autorun Programs / Autostart Programme ------------------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Get-CimInstance -ClassName Win32_StartupCommand | Select-Object -Property Command, Description, User, Location | Format-Table -AutoSize | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append -Width 10000
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
# -------------------  User Folder Paths / Benutzerordner Pfade ---------------- START -------------------
Write-Host "User Folder Paths / Benutzerordner Pfade `n"
Write-Output "---------- User Folder Paths / Benutzerordner Pfade ---------- START --------------------"  | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

# https://docs.microsoft.com/en-us/dotnet/api/system.environment.specialfolder?redirectedfrom=MSDN&view=netcore-3.1
#
# Write-Host Home: $env:HOME
# Write-Host HomeDrive: $env:HOMEDRIVE
# Write-Host Homepath: $env:HOMEPATH
# Write-Host HomeShare: $env:HOMESHARE

# UserProfile Folder
$CurrUserProfile=[environment]::getfolderpath("UserProfile")

# Folders under "UserProfile"
$CurrUserDesktop=[environment]::getfolderpath("Desktop")
# $CurrUserDesktop=[environment]::getfolderpath("DesktopDirectory")
$CurrUserDocuments=[environment]::getfolderpath("MyDocuments")
# $CurrUserPersonalDocs=[environment]::getfolderpath("Personal") # Documents
$CurrUserPictures=[environment]::getfolderpath("MyPictures")
$CurrUserMusic=[environment]::getfolderpath("MyMusic")
$CurrUserVideos=[environment]::getfolderpath("MyVideos")
$CurrUserFavorites=[environment]::getfolderpath("Favorites")

# User Folders "Appdata\Roaming" / "Appdata\Local"
$CurrUserAppdata=[environment]::getfolderpath("ApplicationData")
$CurrUserAppDataLocal=[environment]::getfolderpath("LocalApplicationData")
# User Folders under "Appdata\Roaming"
$CurrUserTemplates=[environment]::getfolderpath("Templates")
$CurrUserStartup=[environment]::getfolderpath("Startup")
$CurrUserRecentList=[environment]::getfolderpath("Recent")
$CurrUserSendTo=[environment]::getfolderpath("SendTo")
$CurrUserNetShortcuts=[environment]::getfolderpath("NetworkShortcuts")
$CurrUserStartmenu=[environment]::getfolderpath("StartMenu")
$CurrUserStartmenuProgs=[environment]::getfolderpath("Programs")
$CurrUserStartmenuAdminTools=[environment]::getfolderpath("AdminTools")

# User Folders under / "Appdata\Local"
$CurrUserInetCache=[environment]::getfolderpath("InternetCache")
$CurrUserInetCookies=[environment]::getfolderpath("Cookies")
$CurrUserHistory=[environment]::getfolderpath("History")
$CurrUserBurn=[environment]::getfolderpath("CDBurning")
$CurrUserTMP = [System.Environment]::GetEnvironmentVariable('TMP','User')
$CurrUserTEMP = [System.Environment]::GetEnvironmentVariable('TEMP','User')
# $CurrUserPrtShort=[environment]::getfolderpath("PrinterShortcuts")




write-Output "`
/--------------------------\ `
`
Home: ........ $env:HOME`
HomeDrive: ... $env:HOMEDRIVE`
Homepath: .... $env:HOMEPATH`
HomeShare: ... $env:HOMESHARE`
`
\--------------------------/
`
/--------------------------\ `
`
# Current User Profile Folders`
`
User Profile / Benutzerprofil: ... $CurrUserProfile
Desktop: ......................... $CurrUserDesktop
Documents / Dokumente: ........... $CurrUserDocuments
Pictures / Bilder: ............... $CurrUserPictures
Music: ........................... $CurrUserMusic
Videos: .......................... $CurrUserVideos
Favorites / Favoriten: ........... $CurrUserFavorites
`
Application Data / Anwendungsdaten: ................ $CurrUserAppdata
local Application Data / lokale Anwendungsdaten: ... $CurrUserAppDataLocal
`
Templates / Vorlagen: ........................ $CurrUserTemplates
Recent / zuletzt Verwendet: .................. $CurrUserRecentList
Send To / Senden an: ......................... $CurrUserSendTo
Network Shortcuts / Netzwerkverknpfungen: ... $CurrUserNetShortcuts
Startmenu / Startmen: ....................... $CurrUserStartmenu
Startmenu Programs / Startmen Programme: .... $CurrUserStartmenuProgs
Startup / Autostart: ......................... $CurrUserStartup
Administrative Tools / Administrator Tools: .. $CurrUserStartmenuAdminTools
`
CD/DVD Temporary Burn Folder: ... $CurrUserBurn`
History / Verlauf: .............. $CurrUserHistory`
Cache: .......................... $CurrUserInetCache`
Cookies: ........................ $CurrUserInetCookies`
TMP (Temp-Folder): .............. $CurrUserTMP`
TEMP (Temp-Folder): ............. $CurrUserTEMP`
`
\--------------------------/" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append

Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
# -------------------  User Folder Paths / Benutzerordner Pfade ---------------- END -------------------
#

#
Write-Host "User Certificates / Benutzer Zertifikate`n"
Write-Output "------ User Certificates / Benutzer Zertifikate ------ START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Get-ChildItem Cert:\CurrentUser\My | Select-Object PolicyId,Subject,Issuer,Thumbprint,Version,Handle,NotBefore,NotAfter | Format-List | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

Write-Host "installed Printers and Printer Driver / installierte Drucker und Drucketreiber`n"
Write-Output "------------ installed Printers and Printer Driver / installierte Drucker und Drucketreiber --------------- START -----" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
  # List of Printers
Get-Printer | Sort-Object -Property  Name | Format-Table -AutoSize | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding utf8 -Append

  # List of Printer Drivers
Get-PrinterDriver | Select-Object Name,@{
    n="DriverVersion";e={

        $ver = $_.DriverVersion
        $rev = $ver -band 0xffff
        $build = ($ver -shr 16) -band 0xffff
        $minor = ($ver -shr 32) -band 0xffff
        $major = ($ver -shr 48) -band 0xffff
        "$major.$minor.$build.$rev"

    }
},Manufacturer,PrinterEnvironment | Sort-Object -Property  Name | Format-Table -AutoSize | Out-File -Width 500 "$ExportPath\$ExportFile" -Encoding utf8 -Append
#
Write-Host "------------------------------------------------------------------`r`n"
write-Output "`n`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
Write-Output "--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--/--\--`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append

# ---- Ausgabe --- END ------ 
#
$DateTXT = Get-Date -format "dd.MM.yyyy - HH:mm:ss tt"
Write-Output "------------------------------------------------------------------" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "Erfassung abgeschlossen: $DateTXT" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "------------------------------------------------------------------`r`n" | Out-File "$ExportPath\$ExportFile" -Encoding utf8 -Append
Write-Output "_______________ - End of File - ______________________`r`n" | Out-File -FilePath $ExportPath\$ExportFile -Encoding utf8 -Append
#
# Get-Content $ExportPath\$ExportFile
# pause
Start-Process notepad.exe $ExportPath\$ExportFile
